	function N = CA_ORDER_HB_Z(wsT, Amin)
	
	% 	Computes the required order for a digital lowpass 
	%	half-band Cauer filter
	%
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2010-11-09
	% 	Modified by: 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1 
	% 	Known bugs:			 
	% 	Report bugs to:	Wanhammar@gmail.com
	%
	
	if  (wsT <= pi/2)
		error('Not a half-band lowpass filter. Must have wsT > /2')  
	elseif ( Amin <= 0)
		error('The stopband attenuation Amin must be > 0')
	elseif ( Amin > 200)
		error('The stopband attenuation is too large')
	end 
	ws = tan(wsT/2);
	wc = tan((pi-wsT)/2);
	% Assume a reasonable large stopband attenuation, Amin > Amax 
	epsilons = sqrt(10^(Amin/10));
	epsilonp = 1/epsilons;
	Amax = 10*log10(1 + epsilonp^2);
	Apn = Amax*log(10)/20;
	epsilon2 = 2*exp(Apn)*sinh(Apn);
	L = sqrt((10^(0.1*Amin) - 1)/epsilon2);
	w = ws/wc;
	Kkl = COMPLETE_ELLIPTIC_INTEGRAL(1/L);
	Kkil = COMPLETE_ELLIPTIC_INTEGRAL(sqrt(1-1/(L*L)));
	Kk1 = COMPLETE_ELLIPTIC_INTEGRAL(sqrt(1-1/(w*w)));
	Kk = COMPLETE_ELLIPTIC_INTEGRAL(1/w);
	N = Kkil/Kkl*Kk/Kk1;	
	
